"use client";

import { cn } from "@/utilities/cn";
import React from "react";
import ButtonLoader from "../Loader/ButtonLoader";

const DefaultButton = React.forwardRef(
  (
    {
      type,
      onClick: onParentClick = () => {},
      block,
      className = "",
      isLoading,
      disabled,
      variant,
      children,
      ...restProps
    },
    ref
  ) => {
    //   const {
    //     type,
    //     onClick,
    //     block,
    //     className,
    //     isLoading,
    //     disabled,
    //     variant,
    //     children,
    //     ...restProps
    //   } = props;

    return (
      <button
        ref={ref}
        className={cn(
          "p-3 rounded-lg text-sm leading-tight font-medium align-middle disabled:opacity-50",
          variant === "fill"
            ? "text-primary bg-teal border-0"
            : "bg-transparent border",
          block ? "w-full" : "w-32",
          disabled
            ? "cursor-not-allowed "
            : "cursor-pointer hover:brightness-95",
          className
        )}
        type={type}
        disabled={disabled || isLoading}
        onClick={onParentClick}
        {...restProps}
      >
        <div className="flex justify-center items-center">
          <ButtonLoader isLoading={isLoading} />
          {children}
        </div>
      </button>
    );
  }
);

DefaultButton.displayName = "DefaultButton";

export default DefaultButton;
