import { cn } from "@/utilities/cn";
import ReactDatePicker from "react-datepicker";

const DatePicker = (props) => {
  const {
    selectsRange,
    isClearable,
    disabled,
    additionalClassName,
    dateFormat,
    isInvalid,
    autoComplete,
    showMonthDropdown,
    showYearDropdown,
    autoFocus,
    placeholderText,
    selected,
    startDate,
    endDate,
    onChange,
    children,
    ...restProps
  } = props;

  const onChangeDate = (dates) => {
    if (onChange) onChange(dates);
  };

  return (
    <ReactDatePicker
      wrapperClassName="w-full"
      className={cn(
        `w-full rounded-lg bg-secondary border-borderColor focus:border-borderColor focus:ring-borderColor placeholder:text-inputPlaceholder`,
        disabled
          ? "cursor-not-allowed text-disableAccent !bg-disableInputBg placeholder:text-disableInputPlaceholder"
          : "cursor-pointer",
        additionalClassName ? additionalClassName : ""
      )}
      selectsRange={selectsRange}
      preventOpenOnFocus
      isClearable={isClearable}
      disabled={disabled}
      dateFormat={dateFormat}
      isInvalid={isInvalid}
      autoComplete={autoComplete}
      showMonthDropdown={showMonthDropdown}
      showYearDropdown={showYearDropdown}
      autoFocus={autoFocus}
      placeholderText={placeholderText}
      selected={selected}
      startDate={startDate}
      endDate={endDate}
      onChange={onChangeDate}
      render
      {...restProps}
    >
      {children}
    </ReactDatePicker>
  );
};

// DatePicker.defaultProps = {
//     selectsRange: false,
//     autoComplete: "off",
//     autoFocus: false,
//     showMonthDropdown: true,
//     showYearDropdown: true,
//     disabled: false,
//     additionalClassName: "",
// };

// DatePicker.propTypes = {
//     selectsRange: PropTypes.bool,
//     autoComplete: PropTypes.string,
//     autoFocus: PropTypes.bool,
//     showMonthDropdown: PropTypes.bool,
//     showYearDropdown: PropTypes.bool,
//     onChange: PropTypes.func.isRequired,
//     disabled: PropTypes.bool,
//     additionalClassName: PropTypes.string,
// };

export default DatePicker;
