const DatePickerFooter = (props) => {
  const { showTodayButton, showCloseButton, onClickClose, onClickToday } =
    props;

  return (
    <div className="h-[325px]">
      {showTodayButton && (
        <span
          className="my-2 absolute bottom-0 left-0 mx-4 p-2 cursor-pointer text-white text-xs rounded-md bg-secondaryButton dark:bg-secondary"
          onClick={() => {
            if (typeof onClickToday === "function") onClickToday();
          }}
        >
          Today
        </span>
      )}
      {showCloseButton && (
        <span
          className="my-2 z-50 absolute bottom-0 right-0 mx-4 p-2 cursor-pointer text-white text-xs rounded-md bg-red-500"
          onClick={() => {
            if (typeof onClickClose === "function") onClickClose();
          }}
        >
          Close
        </span>
      )}
    </div>
  );
};

export default DatePickerFooter;
