"use client";

import React, { useEffect, useRef, useState } from "react";
import PasswordVisibility from "./PasswordVisibility";

function PasswordInput({
  type = "text",
  name = "textHere",
  placeholder = "Please Enter Text",
  value = "",
  onChange = () => {},
  className = "",
  required = false,
  disabled = false,
  ...restProps
}) {
  const [confirmShowPassword, setConfirmShowPassword] = useState(false);
  const inputRef = useRef();
  const changeVisibilityConfirm = () => {
    setConfirmShowPassword(!confirmShowPassword);
  };

  return (
    <div className="relative flex items-center">
      <input
        {...restProps}
        ref={inputRef}
        aria-autocomplete="both"
        aria-haspopup="false"
        autoCapitalize="off"
        autoComplete="off"
        autoCorrect="off"
        spellCheck="false"
        required={required}
        disabled={disabled}
        value={value}
        onChange={onChange}
        name={name}
        type={confirmShowPassword ? "text" : "password"}
        className="w-full px-2 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring focus:ring-blue-500 focus:border-blue-500 disabled:opacity-50 disabled:bg-gray-200 disabled:cursor-not-allowed"
        placeholder={placeholder}
      />
      <PasswordVisibility
        changeVisibility={changeVisibilityConfirm}
        name="password"
        state={confirmShowPassword}
      />
    </div>
  );
}

export default PasswordInput;
