"use client";

import { inject, observer } from "mobx-react";
import { useSession } from "next-auth/react";
import Head from "next/head";
import { usePathname, useRouter } from "next/navigation";
import { useEffect, useState } from "react";
import { ErrorBoundary } from "react-error-boundary";
import CommonHeader from "./CommonHeader";
import { Sidebar } from "./Sidebar";
import PageErrorFallback from "./Sidebar/FallbackError";

function BaseLayout({ authStore, children }) {
  const { getAuth, setAuth } = authStore;
  const { data: session, status } = useSession();
  const router = useRouter();
  const pathName = usePathname();

  const [isLoginPath, setIsLoginPath] = useState(false);

  useEffect(() => {
    if (status === "authenticated") {
      setAuth(true);
    }
  }, [status]);

  useEffect(() => {
    if (pathName === "/login") {
      setIsLoginPath(true);
    } else {
      setIsLoginPath(false);
    }
  }, [pathName]);

  return (
    <div className={`min-h-screen`}>
      <Head>
        <title>ATPL - Attendance Management System</title>
        <meta name="viewport" content="initial-scale=1.0, width=device-width" />
        <meta
          property="og:title"
          content="ATPL - Attendance Management System"
          key="title"
        />

        <link rel="shortcut icon" href="/favicon.png" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
      </Head>

      {getAuth && !isLoginPath && status !== "loading" && <Sidebar />}

      <div className={`${getAuth && "mmd:ml-56"}`}>
        {getAuth && !isLoginPath && status !== "loading" && <CommonHeader />}
        <div className={`bg-primary min-h-screen`}>
          <ErrorBoundary
            FallbackComponent={PageErrorFallback}
            resetKeys={[router]}
          >
            {children}
          </ErrorBoundary>
        </div>
      </div>
    </div>
  );
}

export default inject("authStore")(observer(BaseLayout));
