"use client";

import { LINKS } from "@/constants/Links";
import {
  Menu,
  MenuButton,
  MenuItem,
  MenuItems,
  Transition,
} from "@headlessui/react";

import { get } from "lodash";
import { inject, observer } from "mobx-react";
import { signOut } from "next-auth/react";
import Image from "next/legacy/image";
import Link from "next/link";
import { useRouter } from "next/navigation";
import { Fragment } from "react";
import { FaUserCircle } from "react-icons/fa";
import { HiMenu } from "react-icons/hi";

import MenuLink from "../Button/MenuLink";
import Logo from "./../../public/favicon.png";

const AvatarIcon = () => {
  return (
    <div className="w-10 h-10 relative">
      <FaUserCircle size={40} className="cursor-pointer" />
      <div className="absolute right-0 bottom-0 bg-green-500 w-2.5 h-2.5 border-2 border-white rounded-full"></div>
    </div>
  );
};

function Header({ uiStore, authStore }) {
  const { toggleSidebar } = uiStore;
  const { getMe, getAuth } = authStore;
  const token =
    typeof window !== "undefined" ? window?.localStorage?.getItem("token") : "";

  const router = useRouter();

  const handleLogout = () => {
    signOut();
  };

  const firstName = get(getMe, "firstName", "");
  const lastName = get(getMe, "lastName", "");

  const handleImage = () => {
    router.push("/");
  };

  return (
    <div
      className={`h-14 z-20 pr-3 flex flex-row justify-between ml-auto items-center bg-white shadow-lg sticky top-0 ${
        getAuth && "mmd:justify-end"
      }`}
    >
      {getAuth && (
        <button className="mmd:hidden px-5 text-accent" onClick={toggleSidebar}>
          <HiMenu size={20} />
        </button>
      )}
      {getAuth && (
        <>
          <Menu as="div" className="relative">
            <MenuButton
              as="div"
              className="cursor-pointer rounded-md m-4 text-sm font-medium text-accent focus:outline-none focus-visible:ring-2 focus-visible:ring-white focus-visible:ring-opacity-75"
            >
              <AvatarIcon />
            </MenuButton>
            <Transition
              as={Fragment}
              enter="transition ease-out duration-100"
              enterFrom="transform opacity-0 scale-95"
              enterTo="transform opacity-100 scale-100"
              leave="transition ease-in duration-75"
              leaveFrom="transform opacity-100 scale-100"
              leaveTo="transform opacity-0 scale-95"
            >
              <MenuItems className="absolute right-1 mr-3 w-48 origin-top-right divide-y divide-borderColor rounded-md bg-primary shadow-lg drop-shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none">
                <div className="px-4 py-2 flex flex-row items-center">
                  <AvatarIcon />
                  <div className="flex flex-col px-3">
                    <span className="text-sm font-bold text-accent">
                      {firstName} {lastName}
                    </span>
                  </div>
                </div>
                <div className="py-1 flex flex-col">
                  <MenuItem>
                    <MenuLink
                      className="text:sm py-1 px-4 text-accent hover:bg-default"
                      href={LINKS.SettingsGeneral.path}
                    >
                      Settings
                    </MenuLink>
                  </MenuItem>
                  <MenuItem>
                    <MenuLink
                      className="text:sm py-1 px-4 text-accent hover:bg-default"
                      href={LINKS.SettingsSecurity.path}
                    >
                      Security
                    </MenuLink>
                  </MenuItem>
                </div>
                <div className="flex flex-col">
                  <MenuItem>
                    <span
                      className="text:sm py-3 px-4 text-accent hover:bg-default cursor-pointer"
                      onClick={handleLogout}
                    >
                      Log Out
                    </span>
                  </MenuItem>
                </div>
              </MenuItems>
            </Transition>
          </Menu>
        </>
      )}
    </div>
  );
}

export default inject("uiStore", "authStore")(observer(Header));
