import { usePathname } from "next/navigation";
import React from "react";

function ListHeader({ title, children }) {
  const path = usePathname();
  const pathNameSplit = path && path.split("/");
  const pathName = pathNameSplit && pathNameSplit[pathNameSplit.length - 1];
  return (
    <div className="w-full flex flex-col md:flex-row gap-4 justify-center md:justify-between top-16 px-4 py-4 border-y  border-borderColor drop-shadow-md font-bold text-2xl uppercase text-left bg-default text-accent">
      <div className="text-center md:text-left">
        {title ? title : pathName ? pathName : "Title"}
      </div>
      {children && (
        <div className="flex flex-col md:flex-row gap-4">{children}</div>
      )}
    </div>
  );
}

export default ListHeader;
