import { inject, observer } from "mobx-react";
import { AiFillSetting } from "react-icons/ai";
import { CgProfile } from "react-icons/cg";
import {
  FaFileInvoice,
  FaMoneyCheckAlt,
  FaTachometerAlt,
  FaUsers,
} from "react-icons/fa";
import { MdFingerprint, MdMarkEmailUnread } from "react-icons/md";

import { LINKS } from "@/constants/Links";
import SidebarDropdownMenu from "./SidebarDropdownMenu/SidebarDropdownMenu";
import SidebarMenu from "./SidebarMenu/SidebarMenu";

const Sidebar = ({ uiStore, authStore }) => {
  const { getHelpers } = authStore;
  //   const { getPermission: permission } = permissionStore;
  const { isSidebarOpen, toggleSidebar, currentExpandedMenus } = uiStore;

  const SidebarHeaderItem = (
    <div className="p-4 pb-0">
      <div className="flex h-7 text-3 xl font-extrabold">
        <span>ATPL - AMS</span>
      </div>
    </div>
  );

  const SidebarFooterItem = (
    <div className="mt-auto list-none">
      <SidebarMenu
        active={currentExpandedMenus.includes("settings")}
        title={LINKS.SettingsGeneral.title}
        isPermitted={true}
        path={LINKS.SettingsGeneral.path}
        Icon={<AiFillSetting size={18} className="mr-4 w-5" />}
        expandMenuList={["settings"]}
        checkExpandMenu={"settings"}
        step={1}
      />
    </div>
  );

  const DashboardItem = (
    <SidebarMenu
      active={currentExpandedMenus.includes("dashboard")}
      title={LINKS.dashboard.title}
      isPermitted={true}
      path={LINKS.dashboard.path}
      Icon={<FaTachometerAlt size={18} className="mr-4 w-5" />}
      expandMenuList={["dashboard"]}
      checkExpandMenu={"dashboard"}
      step={1}
    />
  );

  const ApplicationItem = (
    <SidebarDropdownMenu
      active={currentExpandedMenus.includes("application")}
      title={"Application"}
      isPermitted={true}
      Icon={<MdMarkEmailUnread size={18} className="mr-4 w-5" />}
      expandMenuList={["application"]}
      checkExpandMenu={"application"}
      step={1}
    >
      <SidebarMenu
        active={currentExpandedMenus.includes("email")}
        title={LINKS.email.title}
        isPermitted={true}
        path={LINKS.email.path}
        expandMenuList={["application", "email"]}
        checkExpandMenu={"email"}
        step={2}
      />
    </SidebarDropdownMenu>
  );

  const Attendance = (
    <SidebarMenu
      active={currentExpandedMenus.includes("attendance")}
      title={LINKS.attendance.title}
      isPermitted={true}
      Icon={<MdFingerprint size={18} className="mr-4 w-5" />}
      path={LINKS.attendance.path}
      expandMenuList={["attendance"]}
      checkExpandMenu={"attendance"}
      step={1}
    />
  );

  const KPIReport = (
    <SidebarMenu
      active={currentExpandedMenus.includes("kpiReport")}
      title={LINKS.kpiReport.title}
      Icon={<FaFileInvoice size={18} className="mr-4 w-5" />}
      isPermitted={true}
      path={LINKS.kpiReport.path}
      expandMenuList={["kpiReport"]}
      checkExpandMenu={"kpiReport"}
      step={1}
    />
  );

  const Profile = (
    <SidebarMenu
      active={currentExpandedMenus.includes("profile")}
      title={LINKS.profile.title}
      isPermitted={true}
      Icon={<CgProfile size={18} className="mr-4 w-5" />}
      path={LINKS.profile.path}
      expandMenuList={["profile"]}
      checkExpandMenu={"profile"}
      step={1}
    />
  );

  const Employee = (
    <SidebarMenu
      active={currentExpandedMenus.includes("employee")}
      title={LINKS.employee.title}
      isPermitted={true}
      Icon={<FaUsers size={18} className="mr-4 w-5" />}
      path={LINKS.employee.path}
      expandMenuList={["employee"]}
      checkExpandMenu={"employee"}
      step={1}
    />
  );

  const SalaryReport = (
    <SidebarMenu
      active={currentExpandedMenus.includes("salary-report")}
      title={LINKS.salaryReport.title}
      isPermitted={true}
      Icon={<FaMoneyCheckAlt size={18} className="mr-4 w-5" />}
      path={LINKS.salaryReport.path}
      expandMenuList={["salary-report"]}
      checkExpandMenu={"salary-report"}
      step={1}
    />
  );

  //   const SuperAdminItem = (
  //     <SidebarDropdownMenu
  //       active={currentExpandedMenus.includes("super-admin")}
  //       title={"SUPER_ADMIN"}
  //       isPermitted={permission.superAdmin.page}
  //       Icon={<FaUserCog size={18} className="mr-4 w-5" />}
  //       expandMenuList={["super-admin"]}
  //       checkExpandMenu={"super-admin"}
  //       step={1}
  //     >
  //       <SidebarMenu
  //         active={currentExpandedMenus.includes("push-notification")}
  //         title={LINKS.SuperPanelPushNotification.title}
  //         isPermitted={permission.pushNotification.page}
  //         path={LINKS.SuperPanelPushNotification.path}
  //         expandMenuList={["super-admin", "push-notification"]}
  //         checkExpandMenu={"push-notification"}
  //         step={2}
  //       />
  //       <SidebarMenu
  //         active={currentExpandedMenus.includes("script-files")}
  //         title={LINKS.SuperPanelScriptFiles.title}
  //         isPermitted={permission.scriptFiles.page}
  //         path={LINKS.SuperPanelScriptFiles.path}
  //         expandMenuList={["super-admin", "script-files"]}
  //         checkExpandMenu={"script-files"}
  //         step={2}
  //       />
  //       <SidebarDropdownMenu
  //         active={currentExpandedMenus.includes("report")}
  //         title={"REPORT"}
  //         isPermitted={permission.report.page}
  //         expandMenuList={["super-admin", "report"]}
  //         checkExpandMenu={"report"}
  //         step={2}
  //       >
  //         <SidebarMenu
  //           active={currentExpandedMenus.includes("order-summary")}
  //           title={LINKS.SuperPanelOrderAmountSummary.title}
  //           isPermitted={permission.orderAmountSummary.page}
  //           path={LINKS.SuperPanelOrderAmountSummary.path}
  //           expandMenuList={["super-admin", "report", "order-summary"]}
  //           checkExpandMenu={"order-summary"}
  //           step={3}
  //         />
  //         <SidebarMenu
  //           active={currentExpandedMenus.includes("push-notification-list")}
  //           title={LINKS.SuperPanelPushNotificationList.title}
  //           isPermitted={permission.pushNotificationList.page}
  //           path={LINKS.SuperPanelPushNotificationList.path}
  //           expandMenuList={["super-admin", "report", "push-notification-list"]}
  //           checkExpandMenu={"push-notification-list"}
  //           step={3}
  //         />
  //       </SidebarDropdownMenu>
  //       <SidebarMenu
  //         active={currentExpandedMenus.includes("dashboard-messages")}
  //         title={LINKS.SuperPanelDashboardMessages.title}
  //         isPermitted={permission.dashboardMessages.page}
  //         path={LINKS.SuperPanelDashboardMessages.path}
  //         expandMenuList={["super-admin", "dashboard-messages"]}
  //         checkExpandMenu={"dashboard-messages"}
  //         step={2}
  //       />
  //       <SidebarDropdownMenu
  //         active={currentExpandedMenus.includes("procurement-app")}
  //         title={"PROCUREMENT_APP"}
  //         isPermitted={permission.procurementApp.page}
  //         expandMenuList={["super-admin", "procurement-app"]}
  //         checkExpandMenu={"procurement-app"}
  //         step={2}
  //       >
  //         <SidebarMenu
  //           active={currentExpandedMenus.includes("product-wise-report")}
  //           title={LINKS.SuperPanelProcurementProductWiseReport.title}
  //           isPermitted={permission.procurementReportProductWise.page}
  //           path={LINKS.SuperPanelProcurementProductWiseReport.path}
  //           expandMenuList={[
  //             "super-admin",
  //             "procurement-app",
  //             "product-wise-report",
  //           ]}
  //           checkExpandMenu={"product-wise-report"}
  //           step={3}
  //         />
  //         <SidebarMenu
  //           active={currentExpandedMenus.includes("procure-issue-report")}
  //           title={LINKS.SuperPanelProcurementIssueReport.title}
  //           isPermitted={permission.procureIssueReport.page}
  //           path={LINKS.SuperPanelProcurementIssueReport.path}
  //           expandMenuList={[
  //             "super-admin",
  //             "procurement-app",
  //             "procure-issue-report",
  //           ]}
  //           checkExpandMenu={"procure-issue-report"}
  //           step={3}
  //         />
  //       </SidebarDropdownMenu>
  //       <SidebarMenu
  //         active={currentExpandedMenus.includes("dynamic-link")}
  //         title={LINKS.SuperPanelDynamicLink.title}
  //         isPermitted={permission.dynamicLink.page}
  //         path={LINKS.SuperPanelDynamicLink.path}
  //         expandMenuList={["super-admin", "dynamic-link"]}
  //         checkExpandMenu={"dynamic-link"}
  //         step={2}
  //       />
  //       <SidebarMenu
  //         active={currentExpandedMenus.includes("delivery-hub")}
  //         title={LINKS.SuperPanelDeliveryHubLink.title}
  //         isPermitted={permission.deliveryHub.page}
  //         path={LINKS.SuperPanelDeliveryHubLink.path}
  //         expandMenuList={["super-admin", "delivery-hub"]}
  //         checkExpandMenu={"delivery-hub"}
  //         step={2}
  //       />
  //       <SidebarMenu
  //         active={currentExpandedMenus.includes("area-list")}
  //         title={LINKS.SuperPanelAreaList.title}
  //         isPermitted={permission.areaList.page}
  //         path={LINKS.SuperPanelAreaList.path}
  //         expandMenuList={["super-admin", "area-list"]}
  //         checkExpandMenu={"area-list"}
  //         step={2}
  //       />
  //       <SidebarMenu
  //         active={currentExpandedMenus.includes("organization-geo-location")}
  //         title={LINKS.SuperPanelOrgGeoLocationLink.title}
  //         isPermitted={permission.geolocation.page}
  //         path={LINKS.SuperPanelOrgGeoLocationLink.path}
  //         expandMenuList={["super-admin", "organization-geo-location"]}
  //         checkExpandMenu={"organization-geo-location"}
  //         step={2}
  //       />
  //       <SidebarMenu
  //         active={currentExpandedMenus.includes("vacation-management")}
  //         title={LINKS.SuperPanelVacationManagement.title}
  //         isPermitted={permission.vacationManagement.page}
  //         path={LINKS.SuperPanelVacationManagement.path}
  //         expandMenuList={["super-admin", "vacation-management"]}
  //         checkExpandMenu={"vacation-management"}
  //         step={2}
  //       />
  //     </SidebarDropdownMenu>
  //   );

  return (
    <>
      <button
        className={`fixed print:hidden z-40 cursor-default inset-0 bg-slate-400 transition ${
          isSidebarOpen
            ? "opacity-50 pointer-events-auto"
            : "opacity-0 pointer-events-none"
        }`}
        onClick={toggleSidebar}
      ></button>
      <aside
        className={`fixed print:hidden z-40 top-0 transition-[left] duration-200 ${
          isSidebarOpen ? "mmd:left-0 left-0" : "mmd:left-0 -left-56"
        } w-56 h-screen bg-sidebar text-sidebarMenu flex flex-col z-10`}
      >
        {SidebarHeaderItem}
        <nav className="mt-6 relative overflow-y-scroll scrollbar-hide">
          <h6 className="text-xs font-bold px-4 mb-2">MAIN</h6>
          <ul className="text-sm">{DashboardItem}</ul>
          {/* {Object.keys(getHelpers).some((key) => getHelpers[key]) && ( */}
          <div>
            {/* <ul className="text-sm">{StoresItem}</ul> */}
            <h6 className="text-xs font-bold px-4 mt-3 mb-2">COMPONENTS</h6>
            <ul className="text-sm">
              {ApplicationItem}
              {Attendance}
              {KPIReport}
              {Profile}
              {Employee}
              {SalaryReport}
            </ul>
          </div>
          {/* )} */}
        </nav>
        {SidebarFooterItem}
      </aside>
    </>
  );
};

export default inject("uiStore", "authStore")(observer(Sidebar));
