import React from "react";

function Label({
  disabled = false,
  required = false,
  warning = false,
  error = false,
  children,
}) {
  return (
    <div>
      <label
        className={`${
          error
            ? "text-red-600"
            : warning
            ? "text-orange-800"
            : disabled && "text-gray-400 opacity-50"
        } font-semibold mb-2 flex items-center`}
      >
        {children}
        {required && !disabled && (
          <span className="text-red-600 ml-[2px]">*</span>
        )}
      </label>
    </div>
  );
}

export default Label;
