import { getFormattedDate } from "@/utilities/dateHelper";

const prefix = "";

export const LINKS = {
  root: {
    title: "",
    path: `${prefix}/`,
    state: "root",
  },
  login: {
    title: "Login",
    path: `${prefix}/login`,
    state: "login",
  },
  signup: {
    title: "Signup",
    path: `${prefix}/signup`,
    state: "signup",
  },
  serviceError: {
    title: "Service Error",
    path: `${prefix}/service-error`,
    state: "serviceError",
  },
  dashboard: {
    title: "Dashboard Overview",
    path: `${prefix}/dashboard`,
    state: "dashboard",
  },
  SettingsGeneral: {
    title: "Settings General",
    path: `${prefix}/settings/general`,
    state: "SettingsGeneral",
  },
  SettingsSecurity: {
    title: "Settings Security",
    path: `${prefix}/settings/security`,
    state: "SettingsSecurity",
  },
  application: {
    title: "Application",
    path: `${prefix}/application`,
    state: "application",
  },
  pushNotification: {
    title: "Push Notification",
    path: `${prefix}/application/push-notification`,
    state: "pushNotification",
  },
  email: {
    title: "Email",
    path: `${prefix}/application/email`,
    state: "email",
  },
  kpiReport: {
    title: "KPI Report",
    path: `${prefix}/kpi-report`,
    state: "kpiReport",
  },
  attendance: {
    title: "Attendance",
    path: `${prefix}/attendance?check_in_start=${getFormattedDate(
      new Date(),
      "yyyy-MM-dd"
    )}&check_in_end=${getFormattedDate(new Date(), "yyyy-MM-dd")}`,
    state: "attendance",
  },

  profile: {
    title: "Profile",
    path: `${prefix}/profile`,
    state: "profile",
  },
  employee: {
    title: "Employee",
    path: `${prefix}/employee`,
    state: "employee",
  },
  salaryReport: {
    title: "Salary Report",
    path: `${prefix}/salary-report`,
    state: "salaryReport",
  },
};
