export const ENUMS = {
  //   shortReturnLogType: {
  //     short: { value: 1, display: "SHORT" },
  //     return: { value: 2, display: "RETURN" },
  //   },
  employeeInfo: {
    33: {
      value: "33",
      display: "Safwan Ahmad Chowdhury",
    },
    35: {
      value: "35",
      display: "Md. Riadul Haque Shawon",
    },
    50: {
      value: "50",
      display: "Imran Hossain",
    },
    72: {
      value: "72",
      display: "Mahi Sorowar",
    },
    73: {
      value: "73",
      display: "Rahad Hasan",
    },
    142: {
      value: "142",
      display: "Jannatul Fearous",
    },
    143: {
      value: "143",
      display: "Md. Moniruzzaman",
    },
    144: {
      value: "144",
      display: "Md. Nazim Hossain",
    },
    146: {
      value: "146",
      display: "Shafeen Ahmed",
    },
    147: {
      value: "147",
      display: "Md. Sazid Ahmed Tonmoy",
    },
    148: {
      value: "148",
      display: "Nurjahan Akhter",
    },
    149: {
      value: "149",
      display: "Mohammad Tasnimul Hasan",
    },
    152: {
      value: "152",
      display: "Md. Jamil Chowdhury",
    },
    157: {
      value: "157",
      display: "Abir Ahasan Ony",
    },
  },
};

const defaultCreateOptions = ({ key, enumType }) => {
  return { label: enumType[key].display, value: enumType[key].value };
};

export const EnumHelper = ({
  type,
  value,
  display = false,
  property = false,
  color = false,
  options = false,
  createOptions,
}) => {
  const enumType = ENUMS[type];
  const allTheKeys = Object.keys(enumType);

  if (type && value !== undefined) {
    const find = allTheKeys.find((key) => enumType[key].value === value);
    if (display) return enumType[find] ? enumType[find].display : "";
    if (color && find) return enumType[find].color;
    if (property) return find;
    return enumType[find];
  }

  if (type && options) {
    const createdOptions = allTheKeys.map((key) => {
      if (createOptions) return createOptions({ key, enumType });
      return defaultCreateOptions({ key, enumType });
    });
    return createdOptions;
  }
};
