"use client";

import BaseLayout from "@/components/Shared/BaseLayout";
import rootStore from "@/components/stores/RootStore";
import { LINKS } from "@/constants/Links";
import { Provider } from "mobx-react";
import { SessionProvider } from "next-auth/react";
import { usePathname } from "next/navigation";
import { useEffect } from "react";
import { Toaster } from "react-hot-toast";

function Providers({ children }) {
  const pathname = usePathname();

  // Store the previous and current path in local storage
  const storePathValues = () => {
    // eslint-disable-next-line no-undef
    const sessionStorage = globalThis?.sessionStorage;
    // eslint-disable-next-line no-undef
    const currentPath = globalThis?.location?.pathname;

    if (!sessionStorage) return;

    const prevPath = sessionStorage.getItem("currentPath");
    if (
      currentPath === LINKS.login.path ||
      currentPath === LINKS.serviceError.path
    ) {
      sessionStorage.setItem("prevPath", prevPath);
      return;
    }
    if (!prevPath) {
      sessionStorage.setItem("prevPath", currentPath);
      sessionStorage.setItem("currentPath", currentPath);
      return;
    }
    sessionStorage.setItem("prevPath", prevPath);
    // eslint-disable-next-line no-undef
    sessionStorage.setItem("currentPath", currentPath);
  };

  useEffect(() => {
    storePathValues();
  }, [pathname]);

  return (
    <SessionProvider>
      <Provider
        rootStore={rootStore}
        uiStore={rootStore.uiStore}
        authStore={rootStore.authStore}
      >
        <div className={`min-h-screen bg-borderColor`}>
          <BaseLayout>{children}</BaseLayout>
        </div>
        <Toaster
          toastOptions={{ duration: 3000 }}
          containerClassName="print:hidden"
        />
      </Provider>
    </SessionProvider>
  );
}

export default Providers;
