import { Inter } from "next/font/google";
import NextTopLoader from "nextjs-toploader";
import "react-date-range/dist/styles.css";
import "react-date-range/dist/theme/default.css";

import "./globals.css";
import Providers from "./Providers";

const inter = Inter({
  subsets: ["latin"],
  display: "swap",
});

export const metadata = {
  title: "ATPL - Attendance Management System",
  description: "Generated by ATPL Dhaka",
  icons: {
    shortcut: "/favicon.png",
  },
};

export default function RootLayout({ children }) {
  return (
    <html lang="en" className={inter.className}>
      <head>
        <meta
          property="og:title"
          content="ATPL - Attendance Management System"
          key="title"
        />
        <link rel="shortcut icon" href={metadata.icons.shortcut} />
      </head>
      <body className={inter.className}>
        <NextTopLoader
          color="#0CC2AA"
          startPosition={0.3}
          stopDelayMs={300}
          height={2}
          showOnShallow={true}
          options={{ showSpinner: true }}
          shallowRouting
        />
        <Providers>{children}</Providers>
      </body>
    </html>
  );
}
