import { cn } from "@/utilities/cn";
import ButtonLoader from "../Loader/ButtonLoader";

function SubmitButton({
  children,
  loading = false,
  disabled = false,
  variant,
  block,
  className = "",
  ...restProps
}) {
  return (
    <button
      type="submit"
      className={cn(
        "p-3 rounded-lg text-sm flex items-center justify-center leading-tight bg-teal font-medium align-middle disabled:opacity-50",
        variant === "fill"
          ? "text-primary bg-teal border-0"
          : "bg-transparent border",
        block ? "w-full" : "w-32",
        disabled ? "cursor-not-allowed " : "cursor-pointer hover:brightness-95",
        className
      )}
      disabled={disabled || loading}
      {...restProps}
    >
      {loading ? <ButtonLoader isLoading={loading} /> : children}
    </button>
  );
}

export default SubmitButton;
