"use client";

import { signIn, useSession } from "next-auth/react";
import { useEffect, useState } from "react";

import { toastError } from "@/utilities/Toast/toastHelper";
import { inject, observer } from "mobx-react";
import { useRouter } from "next/navigation";
import SubmitButton from "../Button/SubmitButton";
import PasswordInput from "../Input/PasswordInput";
import TextInput from "../Input/TextInput";
import Label from "../Typo/Label";

const initialState = {
  email: "",
  password: "",
};

function LoginForm({ authStore }) {
  const { data: session, status } = useSession();
  const [loading, setLoading] = useState(false);
  const [formData, setFormData] = useState({
    ...initialState,
  });

  const router = useRouter();

  const { setAuth } = authStore;

  const handleSubmit = (e) => {
    e.preventDefault();
    setLoading(true);
    const data = Object.fromEntries(new FormData(e.target).entries());

    signIn("credentials", {
      email: data.email,
      password: data.password,
      redirect: false,
    }).then(({ ok }) => {
      if (ok) {
        router.push("/dashboard");
        setAuth(true);
      } else {
        toastError({ message: "Invalid Credentials" });
      }
      setLoading(false);
    });
  };

  useEffect(() => {
    if (status === "authenticated") {
      setAuth(true);
      router.push("/dashboard");
    }
  }, [status]);

  return (
    <div className="w-full">
      <form className="flex flex-col gap-4" onSubmit={handleSubmit}>
        <div>
          <Label required>Email</Label>
          <TextInput
            type="email"
            name="email"
            placeholder="Enter Your Email"
            required
            value={formData.email}
            onChange={(e) =>
              setFormData({ ...formData, email: e.target.value })
            }
          />
        </div>
        <div>
          <Label required>Password</Label>
          <PasswordInput
            type="password"
            name="password"
            placeholder="Enter Your Password"
            required
            value={formData.password}
            onChange={(e) =>
              setFormData({ ...formData, password: e.target.value })
            }
          />
        </div>
        <div className="w-full">
          <SubmitButton className="w-full bg-tertiary" loading={loading}>
            Login
          </SubmitButton>
        </div>
      </form>
    </div>
  );
}

export default inject("authStore")(observer(LoginForm));
