import DefaultButton from "@/components/Button/DefaultButton";
import Label from "@/components/Typo/Label";
import {
  Popover,
  PopoverButton,
  PopoverPanel,
  Transition,
} from "@headlessui/react";

import {
  addDays,
  addMonths,
  endOfDay,
  endOfMonth,
  format,
  startOfDay,
  startOfMonth,
  subDays,
  subMonths,
} from "date-fns";
import { Fragment, useEffect, useRef, useState } from "react";
import { FiX } from "react-icons/fi";

import TextInput from "../../TextInput";
import DatePicker from "../DatePicker";

const DateRangePicker = (props) => {
  const {
    label0 = "",
    isClearable0 = false,
    dateFormat0 = "",
    isInvalid0 = false,
    placeholder0 = "",
    selected0: parentSelected0,
    startDate0: parentStartDate0,
    endDate0: parentEndDate0,
    minDate0: parentMinDate0,
    error0 = "",
    onChange0,
    label1 = "",
    isClearable1 = false,
    dateFormat1,
    isInvalid1 = false,
    placeholder1 = "",
    selected1: parentSelected1,
    startDate1: parentStartDate1,
    endDate1: parentEndDate1,
    minDate1: parentMinDate1,
    error1 = "",
    onChange1,
    wrapperClass,
    identifier,
    pastDate,
    label,
    placeholder,
    onClear,
    selectsStart = false,
    selectsEnd = false,
    showTimeInput = false,
    ...restProps
  } = props;

  const [startDate0, setStartDate0] = useState(
    parentStartDate0 ? parentStartDate0 : startOfDay(new Date())
  );
  const [endDate0, setEndDate0] = useState(
    parentEndDate0 ? parentEndDate0 : endOfDay(new Date())
  );
  const [selected0, setSelected0] = useState(
    parentSelected0 ? parentSelected0 : startOfDay(new Date())
  );
  const [minDate0, setMinDate0] = useState(parentMinDate0);
  const [startDate1, setStartDate1] = useState(
    parentStartDate1 ? parentStartDate1 : startOfDay(new Date())
  );
  const [endDate1, setEndDate1] = useState(
    parentEndDate1 ? parentEndDate1 : endOfDay(new Date())
  );
  const [selected1, setSelected1] = useState(
    parentSelected1 ? parentSelected1 : endOfDay(new Date())
  );
  const [minDate1, setMinDate1] = useState(parentMinDate1);
  const [showCustomRange, setShowCustomRange] = useState(false);
  const popoverButtonRef = useRef(null);
  const textInputRef = useRef(null);

  const [customSelected0, setCustomSelected0] = useState();
  const [customSelected1, setCustomSelected1] = useState();

  const onChangeDate0 = (date) => {
    setStartDate0(date);
    setStartDate1(date);
    setSelected0(date);
    setCustomSelected0(date);
  };

  const onChangeDate1 = (date) => {
    setEndDate0(date);
    setEndDate1(date);
    setSelected1(date);
    setCustomSelected1(date);
  };

  const onClickClear = () => {
    setCustomSelected0();
    setCustomSelected1();
    if (onClear) onClear();
  };

  useEffect(() => {
    if (
      customSelected0 &&
      customSelected1 &&
      customSelected0 <= customSelected1
    ) {
      if (onChange0) onChange0(customSelected0);
      if (onChange1) onChange1(customSelected1);
    } else if (
      customSelected0 &&
      customSelected1 &&
      customSelected0 > customSelected1
    ) {
      if (onChange0) onChange0();
      if (onChange1) onChange1();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [customSelected0, customSelected1]);

  const onClickCancel = ({ cb }) => {
    if (onChange0 && onChange1) {
      setSelected0(parentSelected0 ? parentSelected0 : startOfDay(new Date()));
      setStartDate0(
        parentStartDate0 ? parentStartDate0 : startOfDay(new Date())
      );
      setEndDate0(
        parentEndDate0 ? endOfDay(parentEndDate0) : endOfDay(new Date())
      );
      setSelected1(
        parentSelected1 ? endOfDay(parentSelected1) : endOfDay(new Date())
      );
      setStartDate1(
        parentStartDate1 ? parentStartDate1 : startOfDay(new Date())
      );
      setEndDate1(
        parentEndDate1 ? endOfDay(parentEndDate1) : endOfDay(new Date())
      );
    }
    if (popoverButtonRef.current) popoverButtonRef.current.click();
  };

  const onClickToday = ({ cb }) => {
    const currentDate = new Date();
    const startDate = startOfDay(currentDate);
    const endDate = endOfDay(currentDate);
    setShowCustomRange(false);

    if (onChange0) onChange0(startDate);
    if (onChange1) onChange1(endDate);
    if (popoverButtonRef.current) popoverButtonRef.current.click();
  };

  const onClickYesterday = ({ cb }) => {
    const currentDate = new Date();
    const startDate = startOfDay(subDays(currentDate, 1));
    const endDate = endOfDay(subDays(currentDate, 1));
    setShowCustomRange(false);

    if (onChange0) onChange0(startDate);
    if (onChange1) onChange1(endDate);
    if (popoverButtonRef.current) popoverButtonRef.current.click();
  };

  const onClickLast7Days = ({ cb }) => {
    const currentDate = new Date();
    const startDate = startOfDay(subDays(currentDate, 6));
    const endDate = endOfDay(currentDate);
    setShowCustomRange(false);

    if (onChange0) onChange0(startDate);
    if (onChange1) onChange1(endDate);
    if (popoverButtonRef.current) popoverButtonRef.current.click();
  };

  const onClickLast30Days = ({ cb }) => {
    const currentDate = new Date();
    const startDate = startOfDay(subDays(currentDate, 29));
    const endDate = endOfDay(currentDate);
    setShowCustomRange(false);

    if (onChange0) onChange0(startDate);
    if (onChange1) onChange1(endDate);
    if (popoverButtonRef.current) popoverButtonRef.current.click();
  };

  const onClickThisMonth = ({ cb }) => {
    const currentDate = new Date();
    const startDate = startOfMonth(currentDate);
    const endDate = endOfMonth(currentDate);
    setShowCustomRange(false);

    if (onChange0) onChange0(startDate);
    if (onChange1) onChange1(endDate);
    if (popoverButtonRef.current) popoverButtonRef.current.click();
  };

  const onClickLastMonth = ({ cb }) => {
    const currentDate = new Date();
    const startDate = startOfMonth(subMonths(currentDate, 1));
    const endDate = endOfMonth(subMonths(currentDate, 1));
    setShowCustomRange(false);

    if (onChange0) onChange0(startDate);
    if (onChange1) onChange1(endDate);
    if (popoverButtonRef.current) popoverButtonRef.current.click();
  };

  const onClickTomorrow = ({ cb }) => {
    const currentDate = new Date();
    const startDate = startOfDay(addDays(currentDate, 1));
    const endDate = endOfDay(addDays(currentDate, 1));
    setShowCustomRange(false);

    if (onChange0) onChange0(startDate);
    if (onChange1) onChange1(endDate);
    if (popoverButtonRef.current) popoverButtonRef.current.click();
  };

  const onClickNext7Days = ({ cb }) => {
    const currentDate = new Date();
    const startDate = startOfDay(currentDate);
    const endDate = endOfDay(addDays(currentDate, 6));
    setShowCustomRange(false);

    if (onChange0) onChange0(startDate);
    if (onChange1) onChange1(endDate);
    if (popoverButtonRef.current) popoverButtonRef.current.click();
  };

  const onClickNext30Days = ({ cb }) => {
    const currentDate = new Date();
    const startDate = startOfDay(currentDate);
    const endDate = endOfDay(addDays(currentDate, 29));
    setShowCustomRange(false);

    if (onChange0) onChange0(startDate);
    if (onChange1) onChange1(endDate);
    if (popoverButtonRef.current) popoverButtonRef.current.click();
  };

  const onClickThisMonthFromToday = ({ cb }) => {
    const currentDate = new Date();
    const startDate = startOfDay(currentDate);
    const endDate = endOfMonth(currentDate);
    setShowCustomRange(false);

    if (onChange0) onChange0(startDate);
    if (onChange1) onChange1(endDate);
    if (popoverButtonRef.current) popoverButtonRef.current.click();
  };

  const onClickNextMonth = ({ cb }) => {
    const currentDate = new Date();
    const startDate = startOfMonth(addMonths(currentDate, 1));
    const endDate = endOfMonth(addMonths(currentDate, 1));
    setShowCustomRange(false);

    if (onChange0) onChange0(startDate);
    if (onChange1) onChange1(endDate);
    if (popoverButtonRef.current) popoverButtonRef.current.click();
  };

  const onClickCustomRange = () => {
    setShowCustomRange(true);
  };

  useEffect(() => {
    setSelected0(
      parentSelected0 ? startOfDay(parentSelected0) : startOfDay(new Date())
    );
    setStartDate0(
      parentStartDate0 ? startOfDay(parentStartDate0) : startOfDay(new Date())
    );
    setEndDate0(
      parentEndDate0 ? endOfDay(parentEndDate0) : endOfDay(new Date())
    );
    setSelected1(
      parentSelected1 ? endOfDay(parentSelected1) : endOfDay(new Date())
    );
    setStartDate1(
      parentStartDate1 ? startOfDay(parentStartDate1) : startOfDay(new Date())
    );
    setEndDate1(
      parentEndDate1 ? endOfDay(parentEndDate1) : endOfDay(new Date())
    );
  }, [
    parentSelected0,
    parentStartDate0,
    parentEndDate0,
    parentSelected1,
    parentStartDate1,
    parentEndDate1,
  ]);

  const PastDatesButtonsList = (
    <div className="flex flex-col space-y-1 items-center">
      <DefaultButton
        variant="outline"
        className="bg-default border-borderColor hover:bg-teal hover:text-default"
        onClick={() => onClickToday({ cb: close })}
      >
        {"TODAY"}
      </DefaultButton>
      <DefaultButton
        variant="outline"
        className="bg-default border-borderColor hover:bg-teal hover:text-default"
        onClick={() => onClickYesterday({ cb: close })}
      >
        {"YESTERDAY"}
      </DefaultButton>
      <DefaultButton
        variant="outline"
        className="bg-default border-borderColor hover:bg-teal hover:text-default"
        onClick={() => onClickLast7Days({ cb: close })}
      >
        {"LAST_7_DAYS"}
      </DefaultButton>
      <DefaultButton
        variant="outline"
        className="bg-default border-borderColor hover:bg-teal hover:text-default"
        onClick={() => onClickLast30Days({ cb: close })}
      >
        {"LAST_30_DAYS"}
      </DefaultButton>
      <DefaultButton
        variant="outline"
        className="bg-default border-borderColor hover:bg-teal hover:text-default"
        onClick={() => onClickThisMonth({ cb: close })}
      >
        {"THIS_MONTH"}
      </DefaultButton>
      <DefaultButton
        variant="outline"
        className="bg-default border-borderColor hover:bg-teal hover:text-default"
        onClick={() => onClickLastMonth({ cb: close })}
      >
        {"LAST_MONTH"}
      </DefaultButton>
      <DefaultButton
        variant="outline"
        className="bg-default border-borderColor hover:bg-teal hover:text-default"
        onClick={() => onClickCustomRange({ cb: close })}
      >
        {"CUSTOM_RANGE"}
      </DefaultButton>
      <div className="py-2 self-stretch">
        <hr className="border-borderColor" />
      </div>
      <div className="flex flex-col space-y-1">
        {/* <DefaultButton onClick={() => onClickApply({ cb: close })}>{("APPLY")}</DefaultButton> */}
        <DefaultButton
          variant="outline"
          className="hover:brightness-90 border-borderColor"
          onClick={() => onClickCancel({ cb: close })}
        >
          {"CANCEL"}
        </DefaultButton>
      </div>
    </div>
  );

  const FutureDatesButtonList = (
    <div className="flex flex-col space-y-1 items-center">
      <DefaultButton
        variant="outline"
        className="bg-default border-borderColor hover:bg-teal hover:text-default"
        onClick={() => onClickToday({ cb: close })}
      >
        {"TODAY"}
      </DefaultButton>
      <DefaultButton
        variant="outline"
        className="bg-default border-borderColor hover:bg-teal hover:text-default"
        onClick={() => onClickTomorrow({ cb: close })}
      >
        {"TOMORROW"}
      </DefaultButton>
      <DefaultButton
        variant="outline"
        className="bg-default border-borderColor hover:bg-teal hover:text-default"
        onClick={() => onClickNext7Days({ cb: close })}
      >
        {"NEXT_7_DAYS"}
      </DefaultButton>
      <DefaultButton
        variant="outline"
        className="bg-default border-borderColor hover:bg-teal hover:text-default"
        onClick={() => onClickNext30Days({ cb: close })}
      >
        {"NEXT_30_DAYS"}
      </DefaultButton>
      <DefaultButton
        variant="outline"
        className="bg-default border-borderColor hover:bg-teal hover:text-default"
        onClick={() => onClickThisMonthFromToday({ cb: close })}
      >
        {"THIS_MONTH_FROM_TODAY"}
      </DefaultButton>
      <DefaultButton
        variant="outline"
        className="bg-default border-borderColor hover:bg-teal hover:text-default"
        onClick={() => onClickNextMonth({ cb: close })}
      >
        {"NEXT_MONTH"}
      </DefaultButton>
      <DefaultButton
        variant="outline"
        className="bg-default border-borderColor hover:bg-teal hover:text-default"
        onClick={() => onClickCustomRange({ cb: close })}
      >
        {"CUSTOM_RANGE"}
      </DefaultButton>
      <div className="py-2 self-stretch">
        <hr className="border-borderColor" />
      </div>
      <div className="flex flex-col space-y-1">
        {/* <DefaultButton onClick={() => onClickApply({ cb: close })}>{("APPLY")}</DefaultButton> */}
        <DefaultButton
          variant="outline"
          className="hover:brightness-90 border-borderColor"
          onClick={() => onClickCancel({ cb: close })}
        >
          {"CANCEL"}
        </DefaultButton>
      </div>
    </div>
  );

  return (
    <div className={`${wrapperClass}`}>
      <Label htmlFor="dateRange">{label ? label : "DATE_RANGE"}</Label>
      <Popover className="relative">
        {({ open, close }) => (
          <>
            <PopoverButton
              ref={popoverButtonRef}
              className="hidden pointer-events-none"
            />
            <div className="relative">
              <TextInput
                ref={textInputRef}
                className="w-full cursor-pointer"
                placeholder={placeholder}
                autoFocus={false}
                value={
                  customSelected0 &&
                  customSelected1 &&
                  customSelected0 <= customSelected1
                    ? `${format(customSelected0, dateFormat0)} - ${format(
                        customSelected1,
                        dateFormat1
                      )}`
                    : parentSelected0 && parentSelected1
                    ? `${format(parentSelected0, dateFormat0)} - ${format(
                        parentSelected1,
                        dateFormat1
                      )}`
                    : ""
                }
                onClick={() => {
                  if (popoverButtonRef.current && !open) {
                    popoverButtonRef.current.click();
                  }
                }}
              />
              <div
                className="absolute bottom-0 right-0 p-3 px-4 cursor-pointer"
                onClick={onClickClear}
              >
                <FiX />
              </div>
            </div>

            <Transition
              as={Fragment}
              enter="transition ease-out duration-200"
              enterFrom="opacity-0 translate-y-1"
              enterTo="opacity-100 translate-y-0"
              leave="transition ease-in duration-150"
              leaveFrom="opacity-100 translate-y-0"
              leaveTo="opacity-0 translate-y-1"
            >
              <PopoverPanel className="absolute left-1/2 mt-4 w-auto -translate-x-1/2 transform lg:max-w-4xl z-20">
                <div className="h-5 w-5 bg-default absolute z-50 left-1/2 -translate-x-1/2 -top-2 rotate-45"></div>
                <div className="overflow-hidden z-20 relative p-4 bg-default rounded-md flex flex-col-reverse sm:flex-row space-x-0 sm:space-x-4 shadow-lg">
                  {pastDate ? PastDatesButtonsList : FutureDatesButtonList}
                  <div
                    className={`flex flex-col sm:flex-row space-x-0 sm:space-x-4 ${
                      showCustomRange ? "block" : "hidden"
                    }`}
                  >
                    <div className="">
                      <Label htmlFor="dateRange0">{label0}</Label>
                      <DatePicker
                        isClearable={isClearable0}
                        dateFormat={dateFormat0}
                        isInvalid={isInvalid0}
                        // selectsStart={selectsStart}
                        showTimeInput={showTimeInput}
                        placeholderText={
                          placeholder0 ? placeholder0 : "DATE_RANGE"
                        }
                        selected={customSelected0 ? customSelected0 : selected0}
                        startDate={startDate0}
                        endDate={endDate0}
                        onChange={onChangeDate0}
                        {...restProps}
                      />
                    </div>
                    <div>
                      <Label htmlFor="dateRange1">{label1}</Label>
                      <DatePicker
                        isClearable={isClearable1}
                        dateFormat={dateFormat1}
                        isInvalid={isInvalid1}
                        minDate={startDate1}
                        // selectsEnd={selectsEnd}
                        showTimeInput={showTimeInput}
                        placeholderText={
                          placeholder1 ? placeholder1 : "DATE_RANGE"
                        }
                        selected={customSelected1 ? customSelected1 : selected1}
                        startDate={startDate1}
                        endDate={endDate1}
                        onChange={onChangeDate1}
                        {...restProps}
                      />
                    </div>
                  </div>
                </div>
              </PopoverPanel>
            </Transition>
          </>
        )}
      </Popover>
    </div>
  );
};

export default DateRangePicker;
