"use client";

import React, { forwardRef } from "react";

const TextInput = forwardRef(
  (
    {
      type = "text",
      name = "textHere",
      placeholder = "Please Enter Text",
      value = "",
      onChange = () => {},
      className = "",
      required = false,
      disabled = false,
      ...restProps
    },
    ref
  ) => {
    return (
      <div className="relative">
        <input
          {...restProps}
          ref={ref}
          aria-autocomplete="both"
          aria-haspopup="false"
          autoCapitalize="off"
          autoComplete="off"
          autoCorrect="off"
          spellCheck="false"
          required={required}
          disabled={disabled}
          value={value}
          onChange={onChange}
          name={name}
          type={type}
          className="w-full px-2 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring focus:ring-blue-500 focus:border-blue-500 disabled:opacity-50 disabled:bg-gray-200 disabled:cursor-not-allowed"
          placeholder={placeholder}
        />
      </div>
    );
  }
);

TextInput.displayName = "TextInput";

export default TextInput;
