import React from "react";
import SubmitButton from "@/components/Button/SubmitButton";

const PageErrorFallback = (props) => {
  const { error, resetErrorBoundary } = props;

  const onResetErrorBoundary = () => {
    resetErrorBoundary();
  };

  return (
    <div className="justify-center items-center gap-2 p-4">
      <h1 className="font-semibold text-lg text-center">
        Something went wrong.
      </h1>
      <SubmitButton
        className="w-auto"
        onClick={() => {
          onResetErrorBoundary();
        }}
      >
        Try Again
      </SubmitButton>
    </div>
  );
};

export default PageErrorFallback;
