const useSearchQuery = (params) => {
  const searchValuesArray = [...params.entries()];
  let searchParams = {};
  if (Array.isArray(searchValuesArray) && searchValuesArray.length > 0) {
    const searchValues = Object.fromEntries(searchValuesArray);
    searchParams = { ...searchValues };
  } else {
    searchParams = {};
  }
  return searchParams;
};

export default useSearchQuery;
