"use client";

import ButtonLoader from "@/components/Loader/ButtonLoader";
import { useSession } from "next-auth/react";
import { usePathname, useRouter } from "next/navigation";
import { useEffect, useState } from "react";

export default function withAuth(Component, role = "") {
  const Authenticated = (props) => {
    // const { redirectTo = LINKS.login.path, authStore, permissionStore } = props;
    const [isLoading, setIsLoading] = useState(true);

    const { data: session, status, update } = useSession();
    const router = useRouter();

    const pathName = usePathname();

    // useEffect(() => {
    //   if (getHelpers?.isOrganizationDistributor === false) {
    //     logout();
    //   }
    // }, [getHelpers]);

    useEffect(() => {
      if (status === "authenticated") {
        setIsLoading(false);
      }
      if (status === "loading") {
        setIsLoading(true);
      }
      if (status === "unauthenticated") {
        router.push("/login");
      }
    }, [status]);

    if (!isLoading && session) {
      return <Component {...props} />;
    }

    if (status === "loading") {
      return <ButtonLoader isLoading />;
    }

    if (!isLoading && session === null) {
      return <h4>You dont have permission.</h4>;
    }

    // here render auth loading spinner if available
    return null;
  };

  Authenticated.displayName = `Authenticated(${getDisplayName(Component)})`;

  return Authenticated;
}

function getDisplayName(WrappedComponent) {
  return WrappedComponent.displayName || WrappedComponent.name || "Component";
}
